<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class aktiva_tetap extends MY_Controller {
	private $data = array();	

	function __construct(){
		parent::__construct();
		$this->load->model('data_master/m_aktiva_tetap');
		$this->load->model('finance_and_acc/m_jurnal');
		error_reporting(E_ALL ^ (E_NOTICE));
	}

	public function index($tipe_trans = null){		

		if($tipe_trans == null || $tipe_trans == 'F' || $tipe_trans == 'f') {
			if(!fcek_hak_akses('.HB7.')){
				redirect('forbidden');
			}

			$tipe_trans = 'F';
		} else {
			if(!fcek_hak_akses('.HB8.')){
				redirect('forbidden');
			}

			if(($this->session->userdata('svlogin') == 'C') && ($tipe_trans == 'C' || $tipe_trans == 'c')) {
				$tipe_trans = 'C';
			} else {
				redirect('aktiva_tetap');
			}
		}

		$data = array();
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		$data['tipe_trans']	= $tipe_trans;
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/aktiva_tetap/v_aktiva_tetap_list',$data);
		$this->load->view('v_footer');			
	}

	public function aktiva_tetap_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'aktiva_tetap');
		
		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['aktiva_tetap_list'] = $this->m_aktiva_tetap->get_aktiva_tetap_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['aktiva_tetap_list']);
		}
		else {
			$pagination['total_list'] = $this->m_aktiva_tetap->get_aktiva_tetap_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['aktiva_tetap_list'] = $this->load->view('data_master/aktiva_tetap/v_aktiva_tetap_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}	

	public function aktiva_tetap_new($tipe_trans = null){	
		if(!fcek_hak_akses('.AT1.')) {
			redirect('forbidden');
		}

		if($tipe_trans == null || $tipe_trans == 'F' || $tipe_trans == 'f') {
			$tipe_trans = 'F';
		} else {
			if(($this->session->userdata('svlogin') == 'C') && ($tipe_trans == 'C' || $tipe_trans == 'c')) {
				$tipe_trans = 'C';
			} else {
				redirect('aktiva_tetap');
			}
		}

		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		$data['tipe_trans']	= $tipe_trans;
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/aktiva_tetap/v_aktiva_tetap_form',$data);
		$this->load->view('v_footer');		
	}

	public function aktiva_tetap_view($msat_no){	
		if(!fcek_hak_akses('.AT0.')) {
			redirect('forbidden');
		}

		if (is_null($msat_no) || !$this->m_aktiva_tetap->get_aktiva_tetap($msat_no)) {
			redirect('aktiva_tetap');
			return;
		}

		$data = array();				
		$data = $this->m_aktiva_tetap->get_aktiva_tetap($msat_no);

		$trju_no = $this->m_jurnal->get_jurnalid($msat_no.'AT');
		// var_dump($trju_no);
		// die();
		if($trju_no != false){			
			$data_jurnal = $this->m_jurnal->get_jurnal($trju_no);			
			$data['jurnal_at_h'] = $data_jurnal['jurnal_h'];
			$data['jurnal_at_d'] = $data_jurnal['jurnal_d'];			
		}

		$trju_no = $this->m_jurnal->get_jurnalid($msat_no.'DA');
		if($trju_no != false){			
			$data_jurnal = $this->m_jurnal->get_jurnal($trju_no);			
			$data['jurnal_da_h'] = $data_jurnal['jurnal_h'];
			$data['jurnal_da_d'] = $data_jurnal['jurnal_d'];			
		}

		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);		
		$data['action'] = 'view';
		$data['tipe_trans']	= $data['header']['msat_fin'];
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/aktiva_tetap/v_aktiva_tetap_form',$data);
		$this->load->view('v_footer');		
	}

	// public function aktiva_tetap_print($msat_no){	
	// 	if (is_null($msat_no) || !$this->m_aktiva_tetap->get_aktiva_tetap($msat_no)) {
	// 		redirect('aktiva_tetap');
	// 		return;
	// 	}
	// 	$data = array();				
	// 	$data = $this->m_aktiva_tetap->get_aktiva_tetap($msat_no);	
	// 	// echo ('<pre>');
	// 	// var_dump($data);
	// 	// die();
	// 	$data['key'] = uniqid();
	// 	$data['hash_key'] = fenkripsi($data['key']);		
	// 	$data['action'] = 'view';		
	// 	$this->load->view('data_master/aktiva_tetap/v_aktiva_tetap_print',$data);		
	// }	

	public function aktiva_tetap_print(){
		$this->load->library('java_bridge');
		$msat_no = $this->input->get('msat_no');
		$paper_size = $this->input->get('paper_size');
		
		$logo = $this->session->userdata('user_aktif')['mscb_logo'];
		$nm_perusahaan = $this->session->userdata('user_aktif')['mscb_prshn_nm'];
		$line1 = $this->session->userdata('user_aktif')['mscb_line1'];
		$line2 = $this->session->userdata('user_aktif')['mscb_line2'];


		if((empty($logo)) || (empty($nm_perusahaan)) || (empty($line1)) || (empty($line2))){
			die("Logo dan data area belum dilengkapi pada menu : data master/company/area/".$this->session->userdata('user_aktif')['mscb_nm']);
		}

		$path = APPPATH.'prints\finance_and_acc\aktiva_tetap\p_aktiva_tetap.jrxml';					
		
		$xml = new DOMDocument();
        $xml->load($path);

        # SET UKURAN KERTAS
        # ----------------------------------------------------------
        $element = $xml->getElementsByTagName("jasperReport")->item(0);
        if ($paper_size == 'A5') {
            // Ukuran A5 dalam satuan pixel
            $element->setAttribute("pageWidth", "595");
            $element->setAttribute("pageHeight", "421");
        } else {
            // Ukuran A4 dalam satuan pixel
            $element->setAttribute("pageWidth", "595");
            $element->setAttribute("pageHeight", "842");
        }
        # ----------------------------------------------------------

        # SET QUERY
        # ----------------------------------------------------------
		$str = "SELECT ms_aktiva_tetap.*
					,DATE_FORMAT(msat_tglbeli, '%d/%m/%Y') AS msat_tglbeli
					,DATE_FORMAT(msat_tglpakai, '%d/%m/%Y') AS msat_tglpakai
					,DATE_FORMAT(msat_disp_tgl, '%d/%m/%Y') AS msat_disp_tgl
					,DATE_FORMAT(msat_last_penyusutan, '%d/%m/%Y') AS msat_last_penyusutan
					,akt.msap_nm AS msap_nm_akt
					,akp.msap_nm AS msap_nm_akp
					,bbp.msap_nm AS msap_nm_bbp
					,disp.msap_nm AS msap_nm_disp
					,msta_nm
					,msta_no
				FROM ms_aktiva_tetap
				LEFT JOIN ms_tipe_asset ON msta_no = msat_msta_no
				LEFT JOIN ms_accper akt ON akt.msap_no = msat_msap_no_akt
				LEFT JOIN ms_accper akp ON akp.msap_no = msat_msap_no_akp
				LEFT JOIN ms_accper bbp ON bbp.msap_no = msat_msap_no_bbp
				LEFT JOIN ms_accper disp ON disp.msap_no = msat_disp_msap_no
				WHERE msat_no = '$msat_no'";

		$aktiva_tetap = $this->db->query($str);
		
		if($aktiva_tetap->num_rows() > 0){
			$aktiva_tetap = $aktiva_tetap->result_array()[0];
		}else{
			die('Tidak ada untuk di print');
		}

		$str = "SELECT md_aktiva_tetap.*
						,msap_nm
				FROM md_aktiva_tetap
				LEFT JOIN ms_accper ON msap_no = mdat_msap_no
				WHERE mdat_no = '$msat_no'";

		$xml->getElementsByTagName("queryString")->item(0)->nodeValue = "";
        $xml->getElementsByTagName("queryString")->item(0)
                ->appendChild($xml->createCDATASection($str));		   		   
        # ----------------------------------------------------------

        $xml->save($path);

		$msat_disp_tgl = ($aktiva_tetap['msat_disp_tgl'] == '00/00/0000') ? '' : $aktiva_tetap['msat_disp_tgl'];
		$msat_last_penyusutan = ($aktiva_tetap['msat_last_penyusutan'] == '00/00/0000') ? '' : $aktiva_tetap['msat_last_penyusutan'];

		$params = new Java("java.util.HashMap");			
		$params->put("msat_disp_tgl",new Java('java.lang.String', $msat_disp_tgl));
		$params->put("msat_disp_catatan",new Java('java.lang.String', $aktiva_tetap['msat_disp_catatan']));
		$params->put("akun_dispose",new Java('java.lang.String', $aktiva_tetap['msat_disp_msap_no'] . ' - ' . $aktiva_tetap['msap_nm_disp']));
		$params->put("msat_last_penyusutan",new Java('java.lang.String', $msat_last_penyusutan));
		$params->put("msat_seq_bln",new Java('java.lang.String', $aktiva_tetap['msat_seq_bln']));
		$params->put("msat_total_penyusutan",new Java('java.lang.Double', $aktiva_tetap['msat_total_penyusutan']));
		$params->put("msat_nilai_awal",new Java('java.lang.Double', $aktiva_tetap['msat_nilai_awal']));
		$params->put("msat_nilai_sisa",new Java('java.lang.Double', $aktiva_tetap['msat_nilai_sisa']));
		$params->put("msat_tglbeli",new Java('java.lang.String', $aktiva_tetap['msat_tglbeli']));
		$params->put("msat_tglpakai",new Java('java.lang.String', $aktiva_tetap['msat_tglpakai']));
		$params->put("msat_catatan",new Java('java.lang.String', $aktiva_tetap['msat_catatan']));
		$params->put("tipe_aktiva",new Java('java.lang.String', $aktiva_tetap['msta_no'] . ' - ' . $aktiva_tetap['msta_nm']));
		$params->put("akun_aktiva",new Java('java.lang.String', $aktiva_tetap['msat_msap_no_akt'] . ' - ' . $aktiva_tetap['msap_nm_akt']));
		$params->put("akun_penyusutan",new Java('java.lang.String', $aktiva_tetap['msat_msap_no_akp'] . ' - ' . $aktiva_tetap['msap_nm_akp']));
		$params->put("akun_beban_penyusutan",new Java('java.lang.String', $aktiva_tetap['msat_msap_no_bbp'] . ' - ' . $aktiva_tetap['msap_nm_bbp']));
		$params->put("P_IMG_PATH",new Java('java.lang.String', $logo));
		$params->put("msat_no",new Java('java.lang.String', $msat_no));
		$params->put("nm_perusahaan_area",new Java('java.lang.String', $nm_perusahaan));
		$params->put("alamat_area",new Java('java.lang.String', $line1));
		$params->put("telp_area",new Java('java.lang.String', $line2));
		$this->java_bridge->print_data($path, $params);
	}

	public function aktiva_tetap_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'aktiva_tetap');		
		$this->form_validation->set_rules($this->config_validation());		
		$vok = true;
		$msg;

		// set data master
		if($vok) {			
			$this->data['action'] = $this->input->post('action');					

			if($this->data['action'] == 'NEW'){
				$this->data['header']['msat_tgl'] = date('Y-m-d H:i:s');
				$this->data['header']['msat_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['header']['msat_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
				$this->data['header']['msat_void'] = 0;
				$this->data['header']['msat_fin'] = $this->input->post('msat_fin');
				$this->data['header']['msat_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('msat_fin') == 'C') ? 'A' : 'R';
			}			

			if($this->data['action'] == 'STCOPY'){				
				$this->data['header']['msat_stcopy'] = ($this->input->post('msat_stcopy') == 'R') ? 'X' : 'R';
			}
			
			$this->data['msat_cekint'] = $this->input->post('msat_cekint');
			$this->data['msat_total_penyusutan'] = ftodouble($this->input->post('msat_total_penyusutan'));
			$this->data['header']['msat_nilai_awal'] = ftodouble($this->input->post('msat_nilai_awal'));
			$this->data['header']['msat_seq_bln'] = ftodouble($this->input->post('msat_seq_bln'));			
			$this->data['header']['msat_lsupd'] = date('Y-m-d H:i:s');
			$this->data['header']['msat_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
			$this->data['header']['msat_no'] = $this->input->post('msat_no');
			$this->data['header']['msat_msta_no'] = $this->input->post('msat_msta_no');				
			$this->data['header']['msat_tglbeli'] = $this->input->post('msat_tglbeli');
			$this->data['header']['msat_tglpakai'] = $this->input->post('msat_tglpakai');
			$this->data['header']['msat_catatan'] = fhapus_kutip($this->input->post('msat_catatan'));
			$this->data['header']['msat_msap_no_akt'] = substr($this->input->post('msat_msap_no_akt'), 0, 11);
			$this->data['header']['msat_msap_no_akp'] = substr($this->input->post('msat_msap_no_akp'), 0, 11);
			$this->data['header']['msat_msap_no_bbp'] = substr($this->input->post('msat_msap_no_bbp'), 0, 11);
			$this->data['header']['msat_nilai_sisa'] = ftodouble($this->input->post('msat_nilai_sisa'));
			$this->data['header']['msat_tag'] = fhapus_kutip($this->input->post('msat_tag'));

			if($this->data['action'] == 'EDIT' || $this->data['action'] == 'VOID'){
				$this->data['userlog']['msul_tgl'] = date('Y-m-d H:i:s');
				$this->data['userlog']['msul_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$this->data['userlog']['msul_catatan'] = substr(trim('['.$this->data['action']. '] ATV.TTP '. $this->data['header']['msat_no']. ' '. fhapus_kutip($this->input->post('msat_tag')). ' '. fhapus_kutip($this->input->post('msat_catatan'))), 0, 250);
			}

			$mdat = $this->input->post('mdat');
			
			if(isset($mdat)){
				foreach ($mdat as $key => $value) {
					for ($i=0; $i < count($mdat[$key]); $i++){					
						if($mdat['mdat_msap_no'][$i] != ''){
							$this->data['detail'][$i]['mdat_no'] = $this->data['header']['msat_no'];
							if($key == 'mdat_jumlah'){
								$this->data['detail'][$i][$key] = ftodouble($value[$i]);
							}else{
								$this->data['detail'][$i][$key] = $value[$i];
							}						
						}
					}
				}					
			}
		}

		// cek form validation
		if($vok){
			if($this->form_validation->run() == FALSE){
				$vok = false;				
				$msg = $this->form_validation->error_array();								
			}
		}		

		// cek valid data master
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_master($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}		

		// set data jurnal
		if($vok){			
			$this->set_data_jurnal($this->data);			
		}		
			
		// simpan data
		if ($vok) {		
			$vresult = $this->m_aktiva_tetap->aktiva_tetap_simpan($this->data);
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}		
		}			

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['msat_no'] = $this->data['header']['msat_no'];
		}				        

		// gagal simpan data
		if (!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;			
		}	

		echo json_encode($result);
	}

	public function aktiva_tetap_dispose(){		
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'aktiva_tetap');		
		$this->form_validation->set_rules($this->config_validation_dispose());		
		$vok = true;

		// set data dispose
		if($vok){
			$this->data['action'] = $this->input->post('action');
			$this->data['msat_cekint'] = $this->input->post('msat_cekint');
			$this->data['header']['msat_no'] = $this->input->post('msat_no');
			$this->data['header']['msat_disp_tgl'] = $this->input->post('msat_disp_tgl');
			$this->data['header']['msat_disp_msap_no'] = substr($this->input->post('msat_disp_msap_no'), 0, 11);
			$this->data['header']['msat_disp_catatan'] = $this->input->post('msat_disp_catatan');
		}

		// cek form validation
		if($vok){
			if($this->form_validation->run() == FALSE){
				$vok = false;				
				$msg = $this->form_validation->error_array();								
			}
		}

		// cek valid data master
		if ($vok) {
			$hasil_cek = $this->cek_valid_data_master($this->data['action'], $this->data);
			if($hasil_cek['valid'] == false){
				$vok = false;				
				$msg = array('error'=>$hasil_cek['msg']);
			}
		}		

		// create jurnal penyusuan asset
		if($vok){
			$this->create_jurnal_penyusutanasset($this->data['header']['msat_disp_tgl'], $this->data['header']['msat_no']);
		}

		// set data jurnal dispose
		if($vok){									
			$data = $this->m_aktiva_tetap->get_aktiva_tetap($this->data['header']['msat_no']);
			$data = $data['header'];
			$data['msat_disp_msap_no'] = $this->data['header']['msat_disp_msap_no'];
			$this->set_data_jurnal_dispose($data);
		}							

		// simpan data
		if ($vok) {		
			$vresult = $this->m_aktiva_tetap->aktiva_tetap_simpan($this->data);
			if($vresult == 0){							
				$vok = false;				
				$msg = array('error'=>'Error query');
			}		
		}			

		// berhasil simpan data
		if ($vok) {
			$this->session->set_userdata('alert_sukses','sukses');
			$result['response'] = 'sukses';
  	 		$result['msat_no'] = $this->data['header']['msat_no'];
		}

		// gagal simpan data
		if(!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;						
		}		

		echo json_encode($result);
	}		

	public function jurnal_bln_penyusutanasset(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'aktiva_tetap');
		$this->data['action'] = 'PENYUSUTAN';
		$vcurrdate = $this->input->post('currdate');
		$vok = true;

		// cek valid penyusutan
		// if ($vok) {
		// 	$hasil_cek = $this->cek_valid_penyusutan($vcurrdate);
		// 	if($hasil_cek['valid'] == false){
		// 		$vok = false;				
		// 		$msg = array('error'=>$hasil_cek['msg']);
		// 	}
		// }				
				
		$vcurrdate = $this->change_currdate_to_lastday($vcurrdate);

		// create jurnal penyusutan
		if($vok) {
			$this->create_jurnal_penyusutanasset($vcurrdate);
		}

		// berhasil create jurnal penyusutan
		if($vok) {			
			$result['response'] = 'sukses';
  	 		$result['msat_no'] = $this->data['header']['msat_no'];
		}

		// gagal simpan data
		if(!$vok) {
			$result['response'] = 'gagal';
			$result['error_message'] = $msg;						
		}		

		echo json_encode($result);
	}	

	private function create_jurnal_penyusutanasset($vcurrdate, $vkhusus_msat_no = null){
		$data = $this->m_aktiva_tetap->get_selectasset($vcurrdate,$vkhusus_msat_no);		
		
		if(count($data) > 0){
			foreach ($data as $key => $value) {
				$vmsat_tglpakai = $data[$key]['msat_tglpakai'];
				$vdd_tglpakai = substr($vmsat_tglpakai, 8, 2);
				$vmm_tglpakai = substr($vmsat_tglpakai, 5, 2);
				$vyyyy_tglpakai = substr($vmsat_tglpakai, 0, 4);				
				$vdd_tgldispose = substr($vcurrdate, 8, 2);
				$vmm_tgldispose = substr($vcurrdate, 5, 2);
				$vyyyy_tgldispose = substr($vcurrdate, 0, 4);				
				$vmsat_seq_bln = $data[$key]['msat_seq_bln'];
				$vmsat_total_penyusutan = $data[$key]['msat_total_penyusutan'];
				$vnumbln_dispose = fdatediff($vmsat_tglpakai, $vcurrdate);
				$vmsat_last_penyusutan = $data[$key]['msat_last_penyusutan'];				
				$tgl_auto = true;				

				if($vkhusus_msat_no == null){
					if($data[$key]['msat_last_penyusutan'] == '0000-00-00'){						
						if($vdd_tglpakai <= 20){
							$vnumbln = 1;
							$vmsat_last_penyusutan = substr($vmsat_tglpakai, 0, 8).cal_days_in_month(CAL_GREGORIAN, $vmm_tglpakai, $vyyyy_tglpakai);
						}else{
							$vnumbln = 2;
							$vmsat_last_penyusutan = fnextyyyymm($vmsat_tglpakai);
						}
						$vnumcurrdate = fdatediff($vmsat_tglpakai, $vcurrdate);
					}else{
						$vnumbln = 2;
						$vnumcurrdate = fdatediff($vmsat_last_penyusutan, $vcurrdate);
						$vmsat_last_penyusutan = fnextyyyymm($data[$key]['msat_last_penyusutan']);
					}
				}else{
					//jika melakukan dispose di bulan yang melebihi umur penyusutan
					if($vdd_tglpakai <= 20){
						$vmsmp_umur = $data[$key]['msmp_umur'];
					}else{
						$vmsmp_umur = $data[$key]['msmp_umur'] + 1;
					}

					if($vnumbln_dispose > $vmsmp_umur){
						if($data[$key]['msat_last_penyusutan'] == '0000-00-00'){							
							if($vdd_tglpakai <= 20){
								$vnumbln = 1;
								$vmsat_last_penyusutan = substr($vmsat_tglpakai, 0, 8).cal_days_in_month(CAL_GREGORIAN, $vmm_tglpakai, $vyyyy_tglpakai);
							}else{
								$vnumbln = 2;
								$vmsat_last_penyusutan = fnextyyyymm($vmsat_tglpakai);
							}
							$vnumcurrdate = fdatediff($vmsat_tglpakai, $vcurrdate);
						}else{
							$vnumbln = 2;
							$vnumcurrdate = fdatediff($vmsat_last_penyusutan, $vcurrdate);
							$vmsat_last_penyusutan = fnextyyyymm($data[$key]['msat_last_penyusutan']);
						}
					}else{															
						//jika melakukan dispose di bulan yang sama atau <= umur penyusutan
						if($vyyyy_tglpakai.$vmm_tglpakai == $vyyyy_tgldispose.$vmm_tgldispose){
							$vnumbln = 1;
							if($vdd_tgldispose > 20){
								$vnumcurrdate = fdatediff($vmsat_tglpakai, $vcurrdate);		
							}else{
								$vnumcurrdate = fdatediff($vmsat_tglpakai, $vcurrdate) - 1;
							}
							$vmsat_last_penyusutan = $vcurrdate;							
						}else{						
							if($data[$key]['msat_last_penyusutan'] == '0000-00-00'){							
								if($vdd_tglpakai <= 20){	
									$vnumbln = 1;
									$vmsat_last_penyusutan = substr($vmsat_tglpakai, 0, 8).cal_days_in_month(CAL_GREGORIAN, $vmm_tglpakai, $vyyyy_tglpakai);
								}else{
									$vnumbln = 2;
									$vmsat_last_penyusutan = fnextyyyymm($vmsat_tglpakai);
								}																									
								$vnumcurrdate = fdatediff($vmsat_tglpakai, $vcurrdate);
							}else{
								$vnumbln = 2;								
								$vnumcurrdate = fdatediff($vmsat_last_penyusutan, $vcurrdate);
								$vmsat_last_penyusutan = fnextyyyymm($data[$key]['msat_last_penyusutan']);		
							}

							if($vdd_tgldispose <= 20){								
								$vnumcurrdate = $vnumcurrdate - 1;
							}else{
								$tgl_auto = false;
							}
						}
					}
				}				

				for ($i=$vnumbln; $i <= $vnumcurrdate; $i++) {
					$vmsat_seq_bln += 1;

					if($tgl_auto == false && $i == $vnumcurrdate){
						$vmsat_last_penyusutan = $vcurrdate;
					}

					if($vmsat_seq_bln <= $data[$key]['msmp_umur']){						
						$value_acc = 0;					
						
						if($data[$key]['msmp_metode'] == 'GL'){
							$value_acc = round((($data[$key]['msat_nilai_awal'] - $data[$key]['msat_nilai_sisa']) * ($data[$key]['msmp_tarif'] / 100)) / 12, 4);						
						}else if($data[$key]['msmp_metode'] == 'DD'){						
							if($vmsat_seq_bln <= 1){
								$value_acc = round((($data[$key]['msat_nilai_awal'] - $data[$key]['msat_nilai_sisa']) * (($data[$key]['msmp_tarif'] * 2) / 100)) / 12, 4);
							}else{							
								$value_acc = round(((($data[$key]['msat_nilai_awal'] - $data[$key]['msat_nilai_sisa']) - $vmsat_total_penyusutan) * (($data[$key]['msmp_tarif'] * 2) / 100)) / 12, 4);
							}					
						}						

						$vmsat_total_penyusutan += $value_acc;						
						$data_jurnal = $data[$key];
						$data_jurnal['msat_last_penyusutan'] = $vmsat_last_penyusutan;
						$data_jurnal['value_acc'] = $value_acc;						
						$this->data['header']['msat_no'] = $data[$key]['msat_no'];
						$this->data['header']['msat_seq_bln'] = $vmsat_seq_bln;
						$this->data['header']['msat_last_penyusutan'] = $vmsat_last_penyusutan;
						$this->data['header']['msat_total_penyusutan'] = $vmsat_total_penyusutan;						
						$this->set_data_jurnal_penyusutanasset($data_jurnal);
						$this->save_data_jurnal_penyusutanasset($this->data);
						$vmsat_last_penyusutan = fnextyyyymm($vmsat_last_penyusutan);
					}else{
						break;
					}					
				}												
			}
		}				
	}

	private function save_data_jurnal_penyusutanasset($data){
		$this->m_aktiva_tetap->save_data_jurnal_penyusutanasset($data);		
	}	

	private function set_data_jurnal_penyusutanasset($data){			
			//Header jurnal						
			$trju_tgl = $data['msat_last_penyusutan'];
			$trju_tipe = 'A';
			$bulan = substr($trju_tgl, 5, 2);
			$tahun = substr($trju_tgl, 2, 2);
			$separator = ($this->input->post('msat_fin') == 'F') ? '-' : '_';
			$trju_kode_depan = "J". $trju_tipe.$tahun.$bulan.$separator;							
			$data['jurnal_h']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);			
			$data['jurnal_h']['trju_refno'] = $data['msat_no'].'PN';
			$data['jurnal_h']['trju_reftipe'] = 'PN';				
			$data['jurnal_h']['trju_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
			$data['jurnal_h']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
			$data['jurnal_h']['trju_tgl'] = $trju_tgl;
			$data['jurnal_h']['trju_tipe'] = $trju_tipe;				
			$data['jurnal_h']['trju_void'] = 0;
			$data['jurnal_h']['trju_catatan'] = $data['msat_no'].'/Penyusutan Aktiva Tetap';
			$data['jurnal_h']['trju_lsupd'] = date('Y-m-d H:i:s');
			$data['jurnal_h']['trju_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];									
			$data['jurnal_h']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('msat_fin') == 'C') ? 'A' : 'R';
			$data['jurnal_h']['trju_fin'] = $this->input->post('msat_fin');
				
			// Set account
			//-----------------------------------------------------------------------------------									
				$array = array();
				$data['jurnal_d'] = array();				
				
				// Akun Beban Penyusutan
				$array['dtju_msap_no'] = $data['msat_msap_no_bbp'];
				$array['dtju_debet'] = $data['value_acc'];
				$array['dtju_kredit'] = 0;
				array_push($data['jurnal_d'], $array);
				
		 		// Kredit-------------------------------------------
		 		// Akun Penyusutan
				$array['dtju_msap_no'] = $data['msat_msap_no_akp'];
				$array['dtju_debet'] = 0;
				$array['dtju_kredit'] = $data['value_acc'];
				array_push($data['jurnal_d'], $array);				
			//--------------------------------------------------------------------------------
			$this->data['jurnal_h'] = $data['jurnal_h'];
			$this->data['jurnal_d'] = $data['jurnal_d'];
	}

	private function set_data_jurnal_dispose($data){		
			//Header jurnal						
			$trju_tgl = $this->input->post('msat_disp_tgl');
			$trju_tipe = 'A';
			$bulan = substr($trju_tgl, 5, 2);
			$tahun = substr($trju_tgl, 2, 2);
			$separator = ($this->input->post('msat_fin') == 'F') ? '-' : '_';
			$trju_kode_depan = "J". $trju_tipe.$tahun.$bulan.$separator;
			$trju_catatan = $data['msat_tag'].' '.$data['msat_no'].'/Dispose Aktiva Tetap';
			$data['jurnal_h']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);			
			$data['jurnal_h']['trju_refno'] = $data['msat_no'].'DA';
			$data['jurnal_h']['trju_reftipe'] = 'DA';			
			$data['jurnal_h']['trju_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
			$data['jurnal_h']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
			$data['jurnal_h']['trju_tgl'] = $trju_tgl;
			$data['jurnal_h']['trju_tipe'] = $trju_tipe;				
			$data['jurnal_h']['trju_void'] = 0;
			$data['jurnal_h']['trju_lsupd'] = date('Y-m-d H:i:s');
			$data['jurnal_h']['trju_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];									
			$data['jurnal_h']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('msat_fin') == 'C') ? 'A' : 'R';
			$data['jurnal_h']['trju_fin'] = $this->input->post('msat_fin');
			$data['jurnal_h']['trju_catatan'] = trim(substr($trju_catatan, 0, 250));
				
			// Set account
			//-----------------------------------------------------------------------------------									
				$array = array();
				$data['jurnal_d'] = array();				
				// Debet---------------------------------------------
				// Akun Akumulasi Penyusutan
				$array['dtju_msap_no'] = $data['msat_msap_no_akp'];
				$array['dtju_debet'] = $data['msat_total_penyusutan'];
				$array['dtju_kredit'] = 0;
				array_push($data['jurnal_d'], $array);
				
		 		// Akun Biaya Lain			 		
				$array['dtju_msap_no'] = $data['msat_disp_msap_no'];
				$array['dtju_debet'] = $data['msat_nilai_awal'] - $data['msat_total_penyusutan'];
				$array['dtju_kredit'] = 0; 
				array_push($data['jurnal_d'], $array);

				// Kredit-------------------------------------------
				// Akun Aktiva
				$array['dtju_msap_no'] = $data['msat_msap_no_akt'];
				$array['dtju_debet'] = 0;
				$array['dtju_kredit'] = $data['msat_nilai_awal'];
				array_push($data['jurnal_d'], $array);				
			//--------------------------------------------------------------------------------
			$this->data['jurnal_h'] = $data['jurnal_h'];
			$this->data['jurnal_d'] = $data['jurnal_d'];		
	}

	private function set_data_jurnal($data){
			//Header jurnal						
			if($data['action'] == 'NEW'){
				$trju_tgl = $data['header']['msat_tglbeli'];
				$trju_tipe = 'A';
				$bulan = substr($trju_tgl, 5, 2);	
				$tahun = substr($trju_tgl, 2, 2);
				$separator = ($this->input->post('msat_fin') == 'F') ? '-' : '_';
				$trju_kode_depan = "J". $trju_tipe.$tahun.$bulan.$separator;							
				$data['jurnal_h']['trju_no'] = $this->m_jurnal->jurnal_kode_auto($trju_kode_depan);
				$data['jurnal_h']['trju_refno'] = $data['header']['msat_no'].'AT';
				$data['jurnal_h']['trju_reftipe'] = 'AT';
				$data['jurnal_h']['trju_msus_no'] = $this->session->userdata('user_aktif')['msus_no'];
				$data['jurnal_h']['trju_mscb_no'] = $this->session->userdata('user_aktif')['msus_mscb_no'];
				$data['jurnal_h']['trju_tgl'] = $trju_tgl;
				$data['jurnal_h']['trju_tipe'] = $trju_tipe;
				$data['jurnal_h']['trju_void'] = 0;
				$data['jurnal_h']['trju_stcopy'] = ($this->session->userdata('svlogin') == 'F' || $this->input->post('msat_fin') == 'C') ? 'A' : 'R';
				$data['jurnal_h']['trju_fin'] = $this->input->post('msat_fin');
			}

			if($data['action'] != 'NEW'){
				$data['jurnal_h']['trju_no'] = $this->input->post('trju_no1');
			}
						
			$trju_catatan = $data['header']['msat_tag'].' '.$data['header']['msat_no']. '/Aktiva Tetap';
			$data['jurnal_h']['trju_catatan'] = trim(substr($trju_catatan, 0, 250));
			$data['jurnal_h']['trju_lsupd'] = date('Y-m-d H:i:s');
			$data['jurnal_h']['trju_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];						
				
			// Set account
			//-----------------------------------------------------------------------------------						
			if(isset($data['detail'])){								
				$array = array();
				$data['jurnal_d'] = array();

				// Akun Aktiva
				$array['dtju_msap_no'] = substr($this->input->post('msat_msap_no_akt'), 0, 11);
				$array['dtju_debet'] = $data['header']['msat_nilai_awal'];
				$array['dtju_kredit'] = 0;
				array_push($data['jurnal_d'], $array);

				foreach ($data['detail'] as $key => $value) {
			 		// Akun Pengeluaran
					$array['dtju_msap_no'] = $data['detail'][$key]['mdat_msap_no'];
					$array['dtju_debet'] = 0;
					$array['dtju_kredit'] = $data['detail'][$key]['mdat_jumlah'];
					array_push($data['jurnal_d'], $array);

					unset($this->data['detail'][$key]['msap_nm']);
				}

				$this->data['jurnal_d'] = $data['jurnal_d'];
			}		
			//--------------------------------------------------------------------------------
			$this->data['jurnal_h'] = $data['jurnal_h'];						
	}

	private function config_validation(){
		$config = array(
		        array(
		                'field' => 'msat_no',
		                'label' => 'ID Aktiva Tetap',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Silakan Input %s. '
		                )
		        ),
		        array(
		                'field' => 'msat_msta_no',
		                'label' => 'Tipe Aktiva Tetap',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Silakan Input %s. '
		                )
		        ),
		        array(
		                'field' => 'msat_msap_no_akt',
		                'label' => 'Akun Aktiva Tetap',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Silakan Input %s. '
		                )
		        ),
		        array(
		                'field' => 'msat_msap_no_akp',
		                'label' => 'Akun Penyusutan',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Silakan Input %s. '
		                )
		        ),
		        array(
		                'field' => 'msat_msap_no_bbp',
		                'label' => 'Akun Beban Penyusutan',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Silakan Input %s. '
		                )
		        ),
		        array(
		                'field' => 'msat_tglbeli',
		                'label' => 'Tanggal Beli',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Silakan Input %s. '
		                )
		        ),
		        array(
		                'field' => 'msat_tglpakai',
		                'label' => 'Tanggal Pakai',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Silakan Input %s. '
		                )
		        )
		);
		return $config;
	}

	private function config_validation_dispose(){
		$config = array(
		        array(
		                'field' => 'msat_disp_tgl',
		                'label' => 'Tgl',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Silakan Input %s. '
		                )
		        ),
		        array(
		                'field' => 'msat_disp_msap_no',
		                'label' => 'Akun Perkiraan',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Silakan Input %s. '
		                )
		        )
		);
		return $config;
	}

	public function cek_valid_data_master($menu, $data){
			// keterangan :
			// $menu = NEW | EDIT | VOID

			$msg = '';
			$hsl = true;			

			if ($hsl && $menu == 'NEW') {
				if($this->m_aktiva_tetap->get_msat_no($data['header']['msat_no'])){
					$hsl = false;
					$msg = 'ID aktiva sudah gunakan. silakan input ID lain';
				}
			}

			if($hsl && $menu != 'DISPOSE') {
				if(!isset($data['detail'])){
					$hsl = false;
					$msg = 'Silakan input pengeluaran';
				}
			}

			// Transaksi yang sudah di rekonsiliasi tidak bisa di edit/void/cancel
			if($hsl && ($menu == 'EDIT' || $menu == 'VOID')) {
				if($this->m_app->is_recon_exists($data['header']['msat_no'].'AT')){
					$hsl = false;
					$msg = 'Transactions cannot be changed. Journal already in reconciliation';
				}
			}

			// utk pengecekan cekint Aktiva Tetap, 
			// Valid = CekInt tidak berubah			
			if ($hsl && $menu != 'NEW') {
				if($this->m_aktiva_tetap->get_aktiva_tetap_cekint($data['header']['msat_no'], $data['msat_cekint']) == false){
					$hsl = false;
					$msg = 'Data have been changed by another user. Please Refresh the page';
				}else{
					$this->m_aktiva_tetap->set_aktiva_tetap_cekint($data['header']['msat_no']);
				}
			}
			
			return array('valid'=>$hsl, 'msg'=>$msg);
	}

	// private function cek_valid_penyusutan($vcurrdate){									
	// 		$msg = '';
	// 		$hsl = true;			
	// 		if($hsl){
	// 			$vdd_currdate = substr($vcurrdate, 8, 2);
	// 			$vmm_currdate = substr($vcurrdate, 5, 2);
	// 			$vyyyy_currdate = substr($vcurrdate, 0, 4);				
	// 			$vdayinamonth = cal_days_in_month(CAL_GREGORIAN, $vmm_currdate, $vyyyy_currdate);
	// 			if($vdd_currdate != $vdayinamonth){
	// 				$hsl = false;
	// 				$msg = 'Belum waktunya penyusutan. Silakan lakukan penyusutan di akhir bulan.';
	// 			}
	// 		}

	// 		return array('valid'=>$hsl, 'msg'=>$msg);
	// }

	private function change_currdate_to_lastday($vcurrdate){
		if($vcurrdate != date("Y-m-t", strtotime($vcurrdate))){
			$vcurrdate = date("Y-m-d", strtotime('-1 month', strtotime($vcurrdate)));
			$vcurrdate =  date("Y-m-t", strtotime($vcurrdate));
		}
		
		return $vcurrdate;
	}	
}	